//******************************************************************************
//* File       : NCursesKeyDef_auto.hpp                                        *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2019-2024 Mahlon R. Smith, The Software Samurai *
//*                 GNU GPL copyright notice below                             *
//* Created    : 2024-06-22T13:37:55                                           *
//*                                                                            *
//* Description: This is an automatically-generated file created by the        *
//*              NcDialogAPI utility "keymap".                                 *
//* This file defines the group of keycodes which are system dependent, and    *
//* vary according to OS distribution, terminal-emulator version, keyboard     *
//* hardware and other factors.                                                *
//*                                                                            *
//* A copy of this file, using default keycode definitions is embedded within  *
//* the NcDialogAPI header file: "NCursesKeyDef.hpp" which defines the         *
//* keyboard keycodes available within the terminal window (gnome-terminal,    *
//* konsole, xterm, etc.).                                                     *
//* The default key map was generated on a clean Fedora system with            *
//* U.S. English keyboard (and numeric keypad)                                 *
//*                                                                            *
//*       kernel-release   : v:6.8.11-200.fc39.x86_64                          *
//*       ncurses C library: v:6.4.20230520                                    *
//*       GNOME terminal   : v:3.50.1                                          *
//*       KDE Konsole      : v:23.08.5                                         *
//*       XTerm            : v:385                                             *
//*                                                                            *
//* For systems which report non-default keycode definitions, a customized     *
//* version of this file may be included within the "NCursesKeyDef.hpp"        *
//* header file. The "#include" statement is under a conditional compilation   *
//* flag as shown below which allows for easily switching between default and  *
//* custom keycodes.                                                           *
//*                                                                            *
//*    //** Conditional Compile:                                               *
//*    //** (1) Use default keycode definitions.                               *
//*    //** (0) Use auto-generated custom keycode definitions.                 *
//*    #define DEFAULT_KEY_DEFINITIONS (1)                                     *
//*                                                                            *
//*    #if DEFAULT_KEY_DEFINITIONS == 0    // Custom Keycode Definitions       *
//*    #include "NCursesKeyDef_auto.hpp"                                       *
//*    #else    // DEFAULT_KEYCODE_DEFINITIONS==(1)                            *
//*    (default key definitions located here....)                              *
//*    #endif   // DEFAULT_KEYCODE_DEFINITIONS                                 *
//*                                                                            *
//* ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ---- ----*
//* This file may be generated with all default values by invoking "keymap"    *
//* with the 'g' option:   keymap -g                                           *
//*                                                                            *
//* Alternatively, the file may be generated after all keycodes have been      *
//* interactively tested.                                                      *
//*                                                                            *
//* Note: While the file may also be generated using data from incomplete      *
//* testing of the keycodes, the resulting keycode definitions may not be      *
//* reliable.                                                                  *
//*                                                                            *
//* If a key combination remains untested, either because it was captured by   *
//* the system or because the test was skipped, then the default keycode and   *
//* escape sequence for that record will be used.                              *
//* If such errors occur during testing please consult the "keymap" log file   *
//* for details; then, disable as many of the system "accelerator keys" as     *
//* possible and run the tests again.                                          *
//*                                                                            *
//******************************************************************************


//*********** Navigation key group (52 keycodes) ***********
//            Key Name       Keycode    Key Esc Sequence (hex)  Key Combination
//            -----------    --------   ----------------------  ---------------------------
const wchar_t nckUP        = 0x0103 ;  // 1B 5B 41              (UpArrow)
const wchar_t nckSUP       = 0x0151 ;  // 1B 5B 31 3B 32 41     (Shift+UpArrow)
const wchar_t nckAUP       = 0x023D ;  // 1B 5B 31 3B 33 41     (Alt+UpArrow)
const wchar_t nckASUP      = 0x023E ;  // 1B 5B 31 3B 34 41     (Alt+Shift+UpArrow)
const wchar_t nckCUP       = 0x023F ;  // 1B 5B 31 3B 35 41     (Ctrl+UpArrow)
const wchar_t nckCSUP      = 0x0240 ;  // 1B 5B 31 3B 36 41     (Ctrl+Shift+UpArrow)
const wchar_t nckACUP      = 0x0241 ;  // 1B 5B 31 3B 37 41     (Alt+Ctrl+UpArrow)
const wchar_t nckDOWN      = 0x0102 ;  // 1B 5B 42              (DownArrow)
const wchar_t nckSDOWN     = 0x0150 ;  // 1B 5B 31 3B 32 42     (Shift+DownArrow)
const wchar_t nckADOWN     = 0x0214 ;  // 1B 5B 31 3B 33 42     (Alt+DownArrow)
const wchar_t nckASDOWN    = 0x0215 ;  // 1B 5B 31 3B 34 42     (Alt+Shift+DownArrow)
const wchar_t nckCDOWN     = 0x0216 ;  // 1B 5B 31 3B 35 42     (Ctrl+DownArrow)
const wchar_t nckCSDOWN    = 0x0217 ;  // 1B 5B 31 3B 36 42     (Ctrl+Shift+DownArrow)
const wchar_t nckACDOWN    = 0x0218 ;  // 1B 5B 31 3B 37 42     (Alt+Ctrl+DownArrow)
const wchar_t nckLEFT      = 0x0104 ;  // 1B 5B 44              (LeftArrow)
const wchar_t nckSLEFT     = 0x0189 ;  // 1B 5B 31 3B 32 44     (Shift+LeftArrow)
const wchar_t nckALEFT     = 0x0228 ;  // 1B 5B 31 3B 33 44     (Alt+LeftArrow)
const wchar_t nckASLEFT    = 0x0229 ;  // 1B 5B 31 3B 34 44     (Alt+Shift+LeftArrow)
const wchar_t nckCLEFT     = 0x022A ;  // 1B 5B 31 3B 35 44     (Ctrl+LeftArrow)
const wchar_t nckCSLEFT    = 0x022B ;  // 1B 5B 31 3B 36 44     (Ctrl+Shift+LeftArrow)
const wchar_t nckACLEFT    = 0x022C ;  // 1B 5B 31 3B 37 44     (Alt+Ctrl+LeftArrow)
const wchar_t nckRIGHT     = 0x0105 ;  // 1B 5B 43              (RightArrow)
const wchar_t nckSRIGHT    = 0x0192 ;  // 1B 5B 31 3B 32 43     (Shift+RightArrow)
const wchar_t nckARIGHT    = 0x0237 ;  // 1B 5B 31 3B 33 43     (Alt+RightArrow)
const wchar_t nckASRIGHT   = 0x0238 ;  // 1B 5B 31 3B 34 43     (Alt+Shift+RightArrow)
const wchar_t nckCRIGHT    = 0x0239 ;  // 1B 5B 31 3B 35 43     (Ctrl+RightArrow)
const wchar_t nckCSRIGHT   = 0x023A ;  // 1B 5B 31 3B 36 43     (Ctrl+Shift+RightArrow)
const wchar_t nckACRIGHT   = 0x023B ;  // 1B 5B 31 3B 37 43     (Alt+Ctrl+RightArrow)
const wchar_t nckPGUP      = 0x0153 ;  // 1B 5B 35 7E           (PageUp)
const wchar_t nckSPGUP     = 0x018E ;  // 1B 5B 35 3B 32 7E     (Shift+PageUp)
const wchar_t nckAPGUP     = 0x0232 ;  // 1B 5B 35 3B 33 7E     (Alt+PageUp)
const wchar_t nckASPGUP    = 0x0233 ;  // 1B 5B 35 3B 34 7E     (Alt+Shift+PageUp)
const wchar_t nckACPGUP    = 0x0236 ;  // 1B 5B 35 3B 37 7E     (Alt+Ctrl+PageUp)
const wchar_t nckPGDOWN    = 0x0152 ;  // 1B 5B 36 7E           (PageDown)
const wchar_t nckSPGDN     = 0x018C ;  // 1B 5B 36 3B 32 7E     (Shift+PageDown)
const wchar_t nckAPGDN     = 0x022D ;  // 1B 5B 36 3B 33 7E     (Alt+PageDown)
const wchar_t nckASPGDN    = 0x022E ;  // 1B 5B 36 3B 34 7E     (Alt+Shift+PageDown)
const wchar_t nckACPGDN    = 0x0231 ;  // 1B 5B 36 3B 37 7E     (Alt+Ctrl+PageDown)
const wchar_t nckHOME      = 0x0106 ;  // 1B 5B 48              (Home)
const wchar_t nckSHOME     = 0x0187 ;  // 1B 5B 31 3B 32 48     (Shift+Home)
const wchar_t nckAHOME     = 0x021E ;  // 1B 5B 31 3B 33 48     (Alt+Home)
const wchar_t nckASHOME    = 0x021F ;  // 1B 5B 31 3B 34 48     (Alt+Shift+Home)
const wchar_t nckCHOME     = 0x0220 ;  // 1B 5B 31 3B 35 48     (Ctrl+Home)
const wchar_t nckCSHOME    = 0x0221 ;  // 1B 5B 31 3B 36 48     (Ctrl+Shift+Home)
const wchar_t nckACHOME    = 0x0222 ;  // 1B 5B 31 3B 37 48     (Alt+Ctrl+Home)
const wchar_t nckEND       = 0x0168 ;  // 1B 5B 46              (End)
const wchar_t nckSEND      = 0x0182 ;  // 1B 5B 31 3B 32 46     (Shift+End)
const wchar_t nckAEND      = 0x0219 ;  // 1B 5B 31 3B 33 46     (Alt+End)
const wchar_t nckASEND     = 0x021A ;  // 1B 5B 31 3B 34 46     (Alt+Shift+End)
const wchar_t nckCEND      = 0x021B ;  // 1B 5B 31 3B 35 46     (Ctrl+End)
const wchar_t nckCSEND     = 0x021C ;  // 1B 5B 31 3B 36 46     (Ctrl+Shift+End)
const wchar_t nckACEND     = 0x021D ;  // 1B 5B 31 3B 37 46     (Alt+Ctrl+End)

//*********** Function key group (48 keycodes) ***********
//            Key Name       Keycode    Key Esc Sequence (hex)  Key Combination
//            -----------    --------   ----------------------  ---------------------------
const wchar_t nckF01       = 0x0109 ;  // 1B 4F 50              (F01)
const wchar_t nckF02       = 0x010A ;  // 1B 4F 51              (F02)
const wchar_t nckF03       = 0x010B ;  // 1B 4F 52              (F03)
const wchar_t nckF04       = 0x010C ;  // 1B 4F 53              (F04)
const wchar_t nckF05       = 0x010D ;  // 1B 5B 31 35 7E        (F05)
const wchar_t nckF06       = 0x010E ;  // 1B 5B 31 37 7E        (F06)
const wchar_t nckF07       = 0x010F ;  // 1B 5B 31 38 7E        (F07)
const wchar_t nckF08       = 0x0110 ;  // 1B 5B 31 39 7E        (F08)
const wchar_t nckF09       = 0x0111 ;  // 1B 5B 32 30 7E        (F09)
const wchar_t nckF10       = 0x0112 ;  // 1B 5B 32 31 7E        (F10)
const wchar_t nckF11       = 0x0113 ;  // 1B 5B 32 33 7E        (F11)
const wchar_t nckF12       = 0x0114 ;  // 1B 5B 32 34 7E        (F12)
const wchar_t nckSF01      = 0x0115 ;  // 1B 5B 31 3B 32 50     (Shift+F01)
const wchar_t nckSF02      = 0x0116 ;  // 1B 5B 31 3B 32 51     (Shift+F02)
const wchar_t nckSF03      = 0x0117 ;  // 1B 5B 31 3B 32 52     (Shift+F03)
const wchar_t nckSF04      = 0x0118 ;  // 1B 5B 31 3B 32 53     (Shift+F04)
const wchar_t nckSF05      = 0x0119 ;  // 1B 5B 31 35 3B 32 7E  (Shift+F05)
const wchar_t nckSF06      = 0x011A ;  // 1B 5B 31 37 3B 32 7E  (Shift+F06)
const wchar_t nckSF07      = 0x011B ;  // 1B 5B 31 38 3B 32 7E  (Shift+F07)
const wchar_t nckSF08      = 0x011C ;  // 1B 5B 31 39 3B 32 7E  (Shift+F08)
const wchar_t nckSF09      = 0x011D ;  // 1B 5B 32 30 3B 32 7E  (Shift+F09)
const wchar_t nckSF10      = 0x011E ;  // 1B 5B 32 31 3B 32 7E  (Shift+F10)
const wchar_t nckSF11      = 0x011F ;  // 1B 5B 32 33 3B 32 7E  (Shift+F11)
const wchar_t nckSF12      = 0x0120 ;  // 1B 5B 32 34 3B 32 7E  (Shift+F12)
const wchar_t nckCF01      = 0x0121 ;  // 1B 5B 31 3B 35 50     (Ctrl+F01)
const wchar_t nckCF02      = 0x0122 ;  // 1B 5B 31 3B 35 51     (Ctrl+F02)
const wchar_t nckCF03      = 0x0123 ;  // 1B 5B 31 3B 35 52     (Ctrl+F03)
const wchar_t nckCF04      = 0x0124 ;  // 1B 5B 31 3B 35 53     (Ctrl+F04)
const wchar_t nckCF05      = 0x0125 ;  // 1B 5B 31 35 3B 35 7E  (Ctrl+F05)
const wchar_t nckCF06      = 0x0126 ;  // 1B 5B 31 37 3B 35 7E  (Ctrl+F06)
const wchar_t nckCF07      = 0x0127 ;  // 1B 5B 31 38 3B 35 7E  (Ctrl+F07)
const wchar_t nckCF08      = 0x0128 ;  // 1B 5B 31 39 3B 35 7E  (Ctrl+F08)
const wchar_t nckCF09      = 0x0129 ;  // 1B 5B 32 30 3B 35 7E  (Ctrl+F09)
const wchar_t nckCF10      = 0x012A ;  // 1B 5B 32 31 3B 35 7E  (Ctrl+F10)
const wchar_t nckCF11      = 0x012B ;  // 1B 5B 32 33 3B 35 7E  (Ctrl+F11)
const wchar_t nckCF12      = 0x012C ;  // 1B 5B 32 34 3B 35 7E  (Ctrl+F12)
const wchar_t nckCSF01     = 0x012D ;  // 1B 5B 31 3B 36 50     (Ctrl+Shift+F01)
const wchar_t nckCSF02     = 0x012E ;  // 1B 5B 31 3B 36 51     (Ctrl+Shift+F02)
const wchar_t nckCSF03     = 0x012F ;  // 1B 5B 31 3B 36 52     (Ctrl+Shift+F03)
const wchar_t nckCSF04     = 0x0130 ;  // 1B 5B 31 3B 36 53     (Ctrl+Shift+F04)
const wchar_t nckCSF05     = 0x0131 ;  // 1B 5B 31 35 3B 36 7E  (Ctrl+Shift+F05)
const wchar_t nckCSF06     = 0x0132 ;  // 1B 5B 31 37 3B 36 7E  (Ctrl+Shift+F06)
const wchar_t nckCSF07     = 0x0133 ;  // 1B 5B 31 38 3B 36 7E  (Ctrl+Shift+F07)
const wchar_t nckCSF08     = 0x0134 ;  // 1B 5B 31 39 3B 36 7E  (Ctrl+Shift+F08)
const wchar_t nckCSF09     = 0x0135 ;  // 1B 5B 32 30 3B 36 7E  (Ctrl+Shift+F09)
const wchar_t nckCSF10     = 0x0136 ;  // 1B 5B 32 31 3B 36 7E  (Ctrl+Shift+F10)
const wchar_t nckCSF11     = 0x0137 ;  // 1B 5B 32 33 3B 36 7E  (Ctrl+Shift+F11)
const wchar_t nckCSF12     = 0x0138 ;  // 1B 5B 32 34 3B 36 7E  (Ctrl+Shift+F12)

//*********** Keypad key group (54 keycodes) ***********
//            Key Name       Keycode    Key Esc Sequence (hex)  Key Combination
//            -----------    --------   ----------------------  ---------------------------
const wchar_t nckpCENTER   = 0x0162 ;  // 1B 5B 45              (keypad Center)
const wchar_t nckpUP       = 0x0103 ;  // 1B 5B 41              (keypad UpArrow)
const wchar_t nckpAUP      = 0x023D ;  // 1B 5B 31 3B 33 41     (keypad Alt+UpArrow)
const wchar_t nckpCUP      = 0x023F ;  // 1B 5B 31 3B 35 41     (keypad Ctrl+UpArrow)
const wchar_t nckpACUP     = 0x0241 ;  // 1B 5B 31 3B 37 41     (keypad Alt+Ctrl+Up)
const wchar_t nckpDOWN     = 0x0102 ;  // 1B 5B 42              (keypad DownArrow)
const wchar_t nckpADOWN    = 0x0214 ;  // 1B 5B 31 3B 33 42     (keypad Alt+DownArrow)
const wchar_t nckpCDOWN    = 0x0216 ;  // 1B 5B 31 3B 35 42     (keypad Ctrl+DownArrow)
const wchar_t nckpACDOWN   = 0x0218 ;  // 1B 5B 31 3B 37 42     (keypad Alt+Ctrl+Down)
const wchar_t nckpLEFT     = 0x0104 ;  // 1B 5B 44              (keypad LeftArrow)
const wchar_t nckpALEFT    = 0x0228 ;  // 1B 5B 31 3B 33 44     (keypad Alt+LeftArrow)
const wchar_t nckpCLEFT    = 0x022A ;  // 1B 5B 31 3B 35 44     (keypad Ctrl+LeftArrow)
const wchar_t nckpACLEFT   = 0x022C ;  // 1B 5B 31 3B 37 44     (keypad Alt+Ctrl+Left)
const wchar_t nckpRIGHT    = 0x0105 ;  // 1B 5B 43              (keypad RightArrow)
const wchar_t nckpARIGHT   = 0x0237 ;  // 1B 5B 31 3B 33 43     (keypad Alt+RightArrow)
const wchar_t nckpCRIGHT   = 0x0239 ;  // 1B 5B 31 3B 35 43     (keypad Ctrl+RightArrow)
const wchar_t nckpACRIGHT  = 0x023B ;  // 1B 5B 31 3B 37 43     (keypad Alt+Ctrl+Right)
const wchar_t nckpINSERT   = 0x014B ;  // 1B 5B 32 7E           (keypad Insert)
const wchar_t nckpAINSERT  = 0x0223 ;  // 1B 5B 32 3B 33 7E     (keypad Alt+Insert)
const wchar_t nckpDELETE   = 0x014A ;  // 1B 5B 33 7E           (keypad Delete)
const wchar_t nckpADEL     = 0x020E ;  // 1B 5B 33 3B 33 7E     (keypad Alt+Delete)
const wchar_t nckpCDEL     = 0x0210 ;  // 1B 5B 33 3B 35 7E     (keypad Ctrl+Delete)
const wchar_t nckpACDEL    = 0x0212 ;  // 1B 5B 33 3B 37 7E     (keypad Alt+Ctrl+Delete)
const wchar_t nckpPGUP     = 0x0153 ;  // 1B 5B 35 7E           (keypad PageUp)
const wchar_t nckpAPGUP    = 0x0232 ;  // 1B 5B 35 3B 33 7E     (keypad Alt+PageUp)
const wchar_t nckpCPGUP    = 0x0234 ;  // 1B 5B 35 3B 35 7E     (keypad Ctrl+PageUp)
const wchar_t nckpACPGUP   = 0x0236 ;  // 1B 5B 35 3B 37 7E     (keypad Alt+Ctrl+PageUp)
const wchar_t nckpPGDN     = 0x0152 ;  // 1B 5B 36 7E           (keypad PageDown)
const wchar_t nckpAPGDN    = 0x022D ;  // 1B 5B 36 3B 33 7E     (keypad Alt+PageDown)
const wchar_t nckpCPGDN    = 0x022F ;  // 1B 5B 36 3B 35 7E     (keypad Ctrl+PageDown)
const wchar_t nckpACPGDN   = 0x0231 ;  // 1B 5B 36 3B 37 7E     (keypad Alt+Ctrl+PageDown)
const wchar_t nckpHOME     = 0x0106 ;  // 1B 5B 48              (keypad Home)
const wchar_t nckpAHOME    = 0x021E ;  // 1B 5B 31 3B 33 48     (keypad Alt+Home)
const wchar_t nckpCHOME    = 0x0220 ;  // 1B 5B 31 3B 35 48     (keypad Ctrl+Home)
const wchar_t nckpACHOME   = 0x0222 ;  // 1B 5B 31 3B 37 48     (keypad Alt+Ctrl+Home)
const wchar_t nckpEND      = 0x0168 ;  // 1B 5B 46              (keypad End)
const wchar_t nckpAEND     = 0x0219 ;  // 1B 5B 31 3B 33 46     (keypad Alt+End)
const wchar_t nckpCEND     = 0x021B ;  // 1B 5B 31 3B 35 46     (keypad Ctrl+End)
const wchar_t nckpACEND    = 0x021D ;  // 1B 5B 31 3B 37 46     (keypad Alt+Ctrl+End)
const wchar_t nckpPLUS     = 0x0247 ;  // '+'                   (keypad Plus)
const wchar_t nckpMINUS    = 0x024C ;  // '-'                   (keypad Minus)
const wchar_t nckpMULT     = 0x024B ;  // '*'                   (keypad Multiply)
const wchar_t nckpDIV      = 0x0249 ;  // '/'                   (keypad Divide)
const wchar_t nckINSERT    = 0x014B ;  // 1B 5B 32 7E           (Insert key (main keybrd))
const wchar_t nckAINSERT   = 0x0223 ;  // 1B 5B 32 3B 33 7E     (Alt+Insert)
const wchar_t nckDELETE    = 0x014A ;  // 1B 5B 33 7E           (Delete key (main keybrd))
const wchar_t nckSDEL      = 0x017F ;  // 1B 5B 33 3B 32 7E     (Shift+Delete)
const wchar_t nckADEL      = 0x020E ;  // 1B 5B 33 3B 33 7E     (Alt+Delete)
const wchar_t nckASDEL     = 0x020F ;  // 1B 5B 33 3B 34 7E     (Alt+Shift+Delete)
const wchar_t nckCDEL      = 0x0210 ;  // 1B 5B 33 3B 35 7E     (Ctrl+Delete)
const wchar_t nckCSDEL     = 0x0211 ;  // 1B 5B 33 3B 36 7E     (Ctrl+Shift+Delete)
const wchar_t nckBKSP      = 0x0107 ;  // '0x7F' (ASCII Delete) (Backspace)
const wchar_t nckSTAB      = 0x0161 ;  // 1B 5B 5A              (Shift+Tab)
const wchar_t nckpENTER    = 0x0157 ;  // '0x0A' (ASCII Enter)  (keypad Enter)

//** End NCursesKeyDef_auto.hpp **
