//******************************************************************************
//* File       : infoDocTest.hpp                                               *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2014-2025 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 12-Apr-2015                                                   *
//*                                                                            *
//* Description: Class definition for the infoDocTest class.                   *
//*              This class includes examples used in the NcDialog API         *
//*              Texinfo documentation.                                        *
//*              It is instantiated by the Dialogw application, Test07.        *
//*                                                                            *
//*                                                                            *
//* Developed using GNU G++ (Gcc v: 4.8.0)                                     *
//*  under Fedora Release 16, Kernel Linux 3.6.11-4.fc16.i686.PAE              *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"

//* Size of dialog window *
const short tselROWS = 15 ;   // Prompt dialog
const short tselCOLS = 40 ;
const short twinROWS = 24 ;   // Test dialog window
const short twinCOLS = 80 ;

//* Control definitions for controls in infoDocTest dialogs *
enum idpControls : short      // prompt dialog
{
   idpDD = ZERO, idpPB, idpCONTROLS_DEFINED
} ;

enum twinControls : short     // individual tests
{
   twDonePB, twDEFINED
} ;

//* infoDocTest class definition *
class infoDocTest
{
   public:
   virtual ~infoDocTest ( void ) ;  // destructor
   //* Constructor *
   infoDocTest ( short tLines, short tCols, short minY ) ;
   bool idDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void idInteract ( void ) ;       // interact with disgusting, dirty users

   private:
   bool  idOpenPrompt ( void ) ;    // open the 'prompt' dialog window
   void  idStdDialog ( short testNum ) ; // test in stardard window
   void  idCloseDialog ( void ) ;   // close the open dialog (if any)

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   InitCtrl*   icPtr ;              // Pointer to array of control definitions
   short       termLines ;          // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   short       dRows ;              // number of rows in open dialog
   short       dCols ;              // number of columns in open dialog
   attr_t      dColor ;             // Dialog background color
   attr_t      tColor ;             // Title/Heading color
   attr_t      bColor ;             // Dialog bold-text color
   attr_t      hColor ;             // Highlight color
   bool        idOpen ;             // 'true' if dialog opened successfully
} ;

