//********************************************************************************
//* File       : gStringTest.hpp                                                 *
//* Author     : Mahlon R. Smith                                                 *
//*              Copyright (c) 2013-2025 Mahlon R. Smith, The Software Samurai   *
//*                  GNU GPL copyright notice located in NcDialog.hpp            *
//* Date       : 28-Sep-2023                                                     *
//*                                                                              *
//* Description: Class definition for the gStringTest class.                     *
//*              This class exercises the functionality of the gString class.    *
//*              It is instantiated by the Dialogw application, Test06.          *
//*                                                                              *
//*                                                                              *
//* Developed using GNU G++ (Gcc v: 4.8.0)                                       *
//*  under Fedora Release 16, Kernel Linux 3.6.11-4.fc16.i686.PAE                *
//********************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"

//* Size of dialog window *
const short promptROWS = 5 ;  // Prompt dialog
const short promptCOLS = 49 ;
const short basicROWS  = 32 ; // Basic tests
const short basicCOLS  = 109 ;
const short intfmtROWS = 36 ; // Integer-formatting test
const short intfmtCOLS = 132 ;

//* Control definitions for controls in gStringTest dialogs *
enum gtpControls : short      // prompt dialog
{
   pBasicPB = ZERO, pIntFmtPB, pDonePB, pCONTROLS_DEFINED
} ;
enum gtbControls : short      // 'basic test' dialog
{
   bNextPB = ZERO, bDonePB, bPrevPB, bCONTROLS_DEFINED
} ;
enum gtiControls : short      // 'integer format' dialog
{
   iDonePB = ZERO, iRJustRB, iLJustRB, iBit32RB, iBit64RB, 
   iDeciRB, iKibiRB, iNegRB, iSgnRB, iUnitSB, 
   iCONTROLS_DEFINED
} ;

//* Description of gString testing method group *
class gStringTest
{
   public:
   virtual ~gStringTest ( void ) ;  // destructor
   //* Constructor *
   gStringTest ( short tLines, short tCols, short minY ) ;
   bool gtDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void gtInteract ( void ) ;       // interact with disgusting, dirty users

   private:
   bool  gtOpenPrompt ( void ) ;    // open the 'prompt' dialog window
   short gtPromptUI ( void ) ;      // 'prompt' dialog user input

   bool  gtOpenBasic ( void ) ;     // open the 'basic test' dialog window
   void  gtBasicUI ( void ) ;       // 'basic test' dialog user input
   void  gtBasicPage1 ( void ) ;    // 'basic test' output 1
   void  gtBasicPage2 ( void ) ;    // 'basic test' output 2
   void  gtBasicPage3 ( void ) ;    // 'basic test' output 3
   void  gtBasicPage4 ( void ) ;    // 'basic test' output 4
   void  gtBasicPage5 ( void ) ;    // 'basic test' output 5
   void  gtBasicPage6 ( void ) ;    // 'basic test' output 6
   void  gtBasicPage7 ( void ) ;    // 'basic test' output 7
   void  gtBasicPage8 ( void ) ;    // 'basic test' output 8
   void  gtBasicPage9 ( void ) ;    // 'basic test' output 9
   void  gtBasicPage10 ( void ) ;   // 'basic test' output 10
   void  gtBasicPage11 ( void ) ;   // 'basic test' output 11
   winPos gtBasicStats ( gString& gs, winPos& wp, attr_t dColor ) ;

   bool  gtOpenIntFmt ( void ) ;    // open the 'integer format' dialog window
   void  gtIntFmtUI ( void ) ;      // 'integer format' dialog user input

   void  gtCloseDialog ( void ) ;   // close the open dialog (if any)

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   InitCtrl*   icPtr ;              // Pointer to array of control definitions
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   short       dRows ;              // number of rows in open dialog
   short       dCols ;              // number of columns in open dialog
   short       displayPage ;        // currently-displayed page of data
   attr_t      dColor ;             // Dialog background color
   attr_t      tColor ;             // Title/Heading color
   attr_t      bColor ;             // Dialog bold-text color
   attr_t      hColor ;             // Highlight color
   bool        gtOpen ;             // 'true' if dialog opened successfully
} ;

