//******************************************************************************
//* File       : ThreadTest.hpp                                                *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2014-2025 Mahlon R. Smith, The Software Samurai *
//* Date       : 02-Jan-2020                                                   *
//*                                                                            *
//* Description: Class definition for the ThreadTest class.                    *
//*              This class performs stress testing in an attempt to compromise*
//*              the NcWindow/NcDialog input and output thread safety.         *
//*              It is instantiated by the Dialog4 application, Test07.        *
//*                                                                            *
//*                                                                            *
//* Developed using GNU G++ (Gcc v: 4.8.0)                                     *
//*  under Fedora Release 16, Kernel Linux 3.6.11-4.fc16.i686.PAE              *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"

//* Test #7 uses multi-threading to drive the automatic stress test.    *
//* If your system or compiler does not support C++11 multithreading,   *
//* then set this definition to '0'. See also the Makefile. Note        *
//* specifically, that the pthread library is linked to the application.*
#define ENABLE_TT_MULTITHREAD (1)

//* Size of dialog window *
const short ttROWS = 28 ;           // display lines
const short ttCOLS = 126 ;          // display columns

//* Control definitions for controls in ThreadTest dialog *
enum ttControls : short
{
   ttDonePB = ZERO, ttInputTB, ttSpeedSP, 
   ttControlsDEFINED    // number of controls defined for dialog
} ;

//* Output modes for secondary threads *
enum ttModes : short
{
   ttChar = 1,    // Output using calls to WriteChar()
   ttStrn = 2,    // Output using calls to WriteString()
   ttPara = 3,    // Output using calls to WriteParagraph()
} ;

//* Number of Autobot threads to be launched: Range 1-5 *
const short abTHREADS = 5 ;

//* Description of Test07, Thread Safety test *
class ThreadTest
{
   public:
   virtual ~ThreadTest ( void ) ;   // destructor
   //* Constructor *
   ThreadTest ( short tLines, short tCols, short minY ) ;
   bool ttDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void ttInteract ( void ) ;       // interact with disgusting, dirty users
   //* Autobot thread target method *
   void ttAutoPilot ( attr_t abColor, const winPos& basePos, short oMode ) ;

   private:
   bool  ttOpenDialog ( void ) ;    // open the dialog window

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   thread      autobots[abTHREADS] ;// handles for autobot thread access
   attr_t      abColor[abTHREADS] ; // Autobots' individual display colors
   ttModes     abMode[abTHREADS] ;  // Autobots' output mode (see enum ttModes)
   short       abY,                 // Autobot display positioning
               abX,
               abInc ;
   attr_t      dColor,              // Dialog background color
               bColor ;             // Dialog border color
   bool        ttOpen,              // 'true' if dialog opened successfully
               ttDone ;
} ;

