//******************************************************************************
//* File       : SliderTest.hpp                                                *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2021-2025 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 21-Mar-2025                                                   *
//* Version    : (see SlideTest.cpp)                                           *
//*                                                                            *
//* Description: Class definition for the SlideTest class.                     *
//*              This class provides a dialog window in which all functionality*
//*              of the dctSLIDER class can be tested and demonstrated.        *
//*              The dctSLIDER class defines an NcDialog user-interface        *
//*              control object.                                               *
//*              This test is called as a menu item within the Dialog4         *
//*              application, Test10.                                          *
//*                                                                            *
//* Development Tools: See NcDialog.cpp.                                       *
//******************************************************************************

#include "GlobalDef.hpp"


//** SliderTest class definition **
class SliderTest
{
   public:
   ~SliderTest (void) {}                     // destructor
   SliderTest ( const winPos& wpOrig ) ;     // constructor
   bool  isOpen ( void )
   { return this->dlgOpen ; }

   //* Get minimum terminal dimensions needed for this test dialog.*
   void GetDimensions ( short& rowsNeeded, short& colsNeeded ) ;

   private:
   void  Setup ( const winPos& wpo ) ;    // initial configuration
   void  InitHelpPath ( void ) ;          // initialize help filespec
   void  Cry4Help ( void ) ;              // view documentation
   int   LaunchDefaultApplication ( const char* targFile, bool redirect = true ) ;

   //* Static callback method *
   static short ControlUpdate ( const short currIndex, 
                                const wkeyCode wkey, bool firstTime ) ;

   //** Data Members **
   NcDialog *dp ;             // pointer to NcDialog object
   InitCtrl *icptr ;          // pointer to control-initialization array
   attr_t dColor ;            // dialog base color
   attr_t bColor ;            // dialog border color
   attr_t gColor ;            // dialog dim (grey text) color
   attr_t pbnColor ;          // Pushbutton non-focus color
   attr_t pbfColor ;          // Pushbutton focus color
   attr_t rbnColor ;          // Radiobutton non-focus color
   attr_t rbfColor ;          // Radiobutton focus color
   attr_t slnColorA ;         // Slider group A non-focus color
   attr_t slfColorA ;         // Slider group A focus color
   attr_t slnColorB ;         // Slider group B non-focus color
   attr_t slfColorB ;         // Slider group B focus color
   attr_t slnColorC ;         // Slider group C non-focus color
   attr_t slfColorC ;         // Slider group C focus color
   attr_t slnColorD ;         // Slider group D non-focus color
   attr_t slfColorD ;         // Slider group D focus color
   winPos wpOrig ;            // absolute terminal offset for main dialog

   char helpPath[gsDFLTBYTES] ;// filespec of NcDialogAPI help file (Info format)
   char helpUrl[gsDFLTBYTES] ; // URL to NcDialogAPI help file (HTML format)
   bool dlgOpen ;             // 'true' if dialog opened successfully

} ;   // SliderTest


#if 0    // REFERENCE ONLY
//** Charttest class definition **
class ChartTest
{
   public:
   ~ChartTest (void) {}                      // destructor
   ChartTest ( const winPos& wpOrig ) ;      // constructor
   bool  isOpen ( void )
   { return this->dlgOpen ; }

   //* Get minimum terminal dimensions needed for this test dialog.*
   void GetDimensions ( short& rowsNeeded, short& colsNeeded ) ;

   //* For debugging only: Capture screenshot of the target dialog.*
   void  ScreenCapture ( Chart *chartPtr ) ;

   private:
   void  Setup ( const winPos& wpo ) ;    // initial configuration
   void  BlastOff ( void ) ;              // Launch the Chart object
   void  SetChartDefinition ( void ) ;    // initialize the ChartDef object, etc.
   void  ClearTargetArea ( bool restore = false ) ;
   void  Cry4Help ( void ) ;              // view documentation
   bool  TargetExists ( const gString& trgPath, fmFType& fType ) ;
   bool  GetFileStats ( const gString& trgPath, tnFName& fStats ) ;
   int   LaunchDefaultApplication ( const char* targFile, bool redirect = true ) ;
   void  InitHelpPath ( void ) ;          // locate the help files
   void  DisplayStats ( Chart *cp ) ;     // in header area, display stats on dataset
   void  SwapDatasets ( const void*& currData,  // exercise data-reload methods
                        int32_t& currCount, idataType& currType, bool& currHzb ) ;
   void  StressedHead2Foot ( Chart *cp, wchar_t targetArea ) ; // exercise text-display areas
   void  statMsg ( gString& msg, bool boldAttr = false, bool   // give user a clue
                   center = true, short warn = ZERO ) ;
   void  statMsg ( const char* msg, bool boldAttr = false, 
                   bool center = true, short warn = ZERO ) ;

   //** Data Members **
   NcDialog *dp ;             // pointer to NcDialog object
   InitCtrl *icptr ;          // pointer to control-initialization array
   attr_t dColor ;            // dialog base color
   attr_t tColor ;            // dialog title color
   attr_t bColor ;            // dialog border color
   attr_t hColor ;            // dialog highlight color
   attr_t chbColor ;          // chart base color, grid color, bar color
   attr_t chnColor ;          // chart negative-values color
   attr_t cdbColor ;          // chart border color
                              //** Dialog control colors **
   attr_t pbnColor ;          // Pushbutton non-focus color
   attr_t pbfColor ;          // Pushbutton focus color
   attr_t tbnColor ;          // Textbox non-focus color
   attr_t tbfColor ;          // Textbox focus color
   attr_t ddnColor ;          // Dropdown non-focus color
   attr_t ddfColor ;          // Dropdown focus color
   attr_t spnColor ;          // Spinner non-focus color
   attr_t spfColor ;          // Spinner focus color
   attr_t rbnColor ;          // Radiobutton non-focus color
   attr_t rbfColor ;          // Radiobutton focus color

   winPos wpOrig ;            // absolute terminal offset for main dialog
   ChartDef cdef ;            // chart object setup data

   char   helpPath[xAX_PATH] ;// filespec of NcDialogAPI help file (Info format)
   char   helpUrl[xAX_PATH] ; // URL to NcDialogAPI help file (HTML format)
   bool   dlgOpen ;           // 'true' if dialog opened successfully

} ;
#endif   // REFERENCE ONLY
