//******************************************************************************
//* File       : PinwheelTest.hpp                                              *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2021-2025 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 26-May-2021                                                   *
//* Version    : (see below)                                                   *
//*                                                                            *
//* Description: Class definition for testing of the Pinwheel class.           *
//*              This class provides a dialog window in which all functionality*
//*              of the Pinwheel class can be tested and demonstrated.         *
//*              This test is called as a menu item within the Dialog4         *
//*              application, Test10.                                          *
//*                                                                            *
//* Development Tools: See NcDialog.cpp.                                       *
//******************************************************************************

#include "GlobalDef.hpp"
#include "Pinwheel.hpp"

const short pwCNT = 24 ;      // number of pinwheel objects in main group

//** PinwheelTest class definition **
class PinwheelTest
{
   public:
   ~PinwheelTest (void) {}                   // destructor
   PinwheelTest ( const winPos& wpOrig ) ;   // constructor
   bool  isOpen ( void )
   { return this->dlgOpen ; }

   private:
   void  Setup ( winPos& wpt, short iTick ) ;
   bool  AdvancedSetup ( Pinwheel& advPw, bool forceOff, 
                         bool cChange = false, bool bidir = false ) ;
   void  AdvancedResync ( Pinwheel& advPw, bool all = false ) ;
   void  AdvancedInit ( void ) ;
   void  AdvancedAttrInit ( void ) ;
   void  AdvancedPosition ( bool altPos ) ;
   void  AdvancedMsg ( gString& msg, bool pause = true ) ;
   void  AdvancedMsg ( const char* msg, bool pause = true ) ;
   void  AdvancedDump ( const PinwheelInit *pwiPtr = NULL ) ;
   void  ToggleGroup ( short objIndex, short objCount ) ;
   void  ToggleAll ( short objCount, bool launch ) ;
   void  Speed ( short objIndex, short objCount, short newTick ) ;
   void  statMsg ( gString& msg, bool pause = true ) ;
   void  statMsg ( const char* msg, bool pause = true ) ;

   //* Data Members *
   NcDialog *dp ;             // pointer to NcDialog object
   InitCtrl *icptr ;          // pointer to control-initialization array
   Pinwheel *pw[pwCNT] ;      // array of pointers to main Pinwheel objects
   winPos    wp[pwCNT] ;      // positions of main Pinwheel objects
   PinwheelInit advInit ;     // initialization data for the "advanced" Pinwheel object
   winPos amsgPos ;           // message position in "advanced-testing" area
   winPos msgPos ;            // status-message position
   attr_t msgAttr ;           // message color attribute
   attr_t dColor ;            // dialog base color
   attr_t tColor ;            // dialog title color
   attr_t bColor ;            // dialog border color
   attr_t hColor ;            // dialog highlight color
   attr_t aColor ;            // advanced-testing box color
   attr_t advAttr ;           // color theme for advanced-testing area
   attr_t advAttr1u[pwTicks] ;// advanced single colors (upward/rightward/wheel)
   attr_t advAttr1d[pwTicks] ;// advanced single colors (downward/leftward)
   attr_t advAttr8[pwTicks] ; // advanced multi-color
   short  objWidth ;          // display width of object (columns)
   short  objHeight ;         // display height of object (rows)
   bool   advFlag ;           // external loop-control flag for "advanced" Pinwheel object
   bool   dlgOpen ;           // 'true' if dialog opened successfully

} ;   // PinwheelTest


