//******************************************************************************
//* File       :  DMouseTest.hpp                                               *
//* Author     :  Mahlon R. Smith                                              *
//*              Copyright (c) 2013-2025 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       :  02-Jan-2020                                                  *
//*                                                                            *
//* Description: Class definition for the DMouseTest class.                    *
//*              This class exercises the NcDialog-class mouse methods.        *
//*              It is instantiated by the Dialog4 application, Test04.        *
//*                                                                            *
//*                                                                            *
//* Developed using GNU G++ (Gcc v: 4.8.0)                                     *
//*  under Fedora Release 16, Kernel Linux 3.6.11-4.fc16.i686.PAE              *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"

//* Size of dialog window *
const short ndmROWS = 30 ;
const short ndmCOLS = 120 ;

//* Control definitions for controls in ColorTest dialog *
enum  dmControls : short
{  //* Functional controls *
   dmDonePB = ZERO, dmOutBB, dmMaskSE, dmMaskTB, dmFilterRB, dmWheelRB, 
   dmAutoRB, dmStableRB, dmDelaySP, dmClearPB, 
   //* Do-nothing controls for testing *
   dmShowPB, dmIndiRB, dmGrp1RB, dmGrp2RB, dmGrp3RB, dmGenTB, 
   /*dmGenBB,*/ dmGenDD, dmGenSB, dmIndiMW, 
   dmGrp1MW, dmGrp2MW, dmGrp3MW, dmSub3MW, dmConMW,
   dmControlsDEFINED
} ;

//* Description of Test04, NcDialog mouse-testing method group *
class DMouseTest
{
   public:
   virtual ~DMouseTest ( void ) ;   // destructor
   //* Constructor *
   DMouseTest ( short tLines, short tCols, short minY ) ;
   bool dmDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void dmInteract ( void ) ;       // interact with disgusting, dirty users

   private:
   bool dmOpenDialog ( void ) ;     // open the dialog window
   void dmInitSE ( void ) ;         // initialize event-mask selector control
   bool dmSetEMask ( void ) ;       // set new event-mask from selector control data
   void dmSynch2EMask ( void ) ;    // synchronize display to event-mask
   void dmUpdateTBox ( mmask_t cmask ) ; // update view-only textbox text

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       dRows ;              // size of dialog in Y
   short       dCols ;              // size of dialog in X
   short       minULY ;             // first available display row in termwin
   attr_t      dColor ;             // Dialog background color
   attr_t      bColor ;             // Dialog border color
   bool        dmOpen ;             // 'true' if dialog opened successfully
} ;

