//******************************************************************************
//* File       : KeyTest.hpp                                                   *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2013-2024 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 02-Jun-2020                                                   *
//*                                                                            *
//* Description: Class definition for the KeyTest class.                       *
//*              This class exercises the NCurses/NcDialog keyboard input      *
//*              stream. It is instantiated by the Dialog2 application, Test05.*
//*                                                                            *
//*                                                                            *
//* Developed using GNU G++ (Gcc v: 4.8.0)                                     *
//*  under Fedora Release 16, Kernel Linux 3.6.11-4.fc16.i686.PAE              *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"
#include <fstream>

//* Size of dialog window *
const short ktdROWS = 35 ;
const short ktdCOLS = 96 ;

//* Control definitions for controls in KeyTest dialog *
enum ktControls : short
{
   ktKeycode32RB = ZERO, ktKeycode16RB, 
   ktNotransRB, ktRawRB, ktUnbufRB, ktCookedRB, 
   ktForeverRB, ktNowaitRB, ktVariableRB, ktDelaySP, 
   ktMouseRB, ktHelpPB, ktLogPB, ktDonePB, ktSextKeySE, 
   ktControlsDEFINED
} ;

const short ssdMAX = 1024 ;   // Maximum entries in display-data array

//* Description of Test05, key-input testing method group *
class KeyTest
{
   public:
   virtual ~KeyTest ( void ) ;      // destructor
   //* Constructor *
   KeyTest ( short tLines, short tCols, short minY ) ;
   bool ktDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void ktInteract ( void ) ;       // interact with disgusting, dirty users

   private:
   bool ktOpenDialog ( void ) ;     // open the dialog window
   void ktGetUserInput ( void ) ;   // interact with user
   void ktReinitSSD ( void ) ;      // reinitialize input area
   bool ktLogPrompt ( bool decide );// ask user about log-file creation
   void ktLog ( void ) ;            // write data to log file
   void ktHelp ( void ) ;           // display help for key-input test

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   ssetData    ssd ;                // Display data for input area
   char        ssdText[ssdMAX][MAX_DIALOG_WIDTH] ;// Display-data strings
   char*       ssdtPtr[ssdMAX] ;    // Display-data pointers
   attr_t      ssdAttr[ssdMAX] ;    // Display-data color attributes
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   attr_t      dColor ;             // Dialog background color
   ncKeyDelay  keyDelay ;           // key-input delay
   bool        wideKeys ;           // 'true' if 32-bit key input
   bool        dataLog ;            // 'true' if log-file out put enabled
   bool        ktOpen ;             // 'true' if dialog opened successfully
} ;

