//********************************************************************************
//* File       : NCursesKeyDef.hpp                                               *
//* Author     : Mahlon R. Smith                                                 *
//*              Copyright (c) 2005-2025 Mahlon R. Smith, The Software Samurai   *
//*                 GNU GPL copyright notice located in NCurses.hpp              *
//* Date       : 20-Mar-2025                                                     *
//*                                                                              *
//* Description: Key definitions for the NCurses class.                          *
//*              Many definitions are single-code translations of xterm          *
//*              escape sequences captured by the underlying ncurses C code.     *
//*              Others are assigned after capture and translation of ESC        *
//*              sequences by methods in the NCurses class.                      *
//*                                                                              *
//*  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---   *
//* IMPORTANT NOTE:                                                              *
//* The file "NCursesKeyDef_auto.hpp" is optionally "#include'd" in this file.   *
//* The included file contains programatically-generated keycode definitions     *
//* for key combinations that vary according to OS distribution, ncurses C       *
//* library version, and terminal emulator (terminfo definitions, etc.).         *
//*  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---   *
//*  Default keycode table generated by Keymap utility, 2024-06-01T16:20:00      *
//*    Fedora Linux v:6.8.10-200.fc39.x86_64                                     *
//*    U.S. English keyboard (with numeric keypad)                               *
//*    ncurses C library: v:6.4.202300520                                        *
//*    GNOME terminal   : v:3.50.1                                               *
//*  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---   *
//*                                                                              *
//* If one or more keycodes defined in that file do not match the keycodes       *
//* reported by the target system, the file can be re-generated to reflect the   *
//* actual keycode used by the target system. For details, please refer to       *
//* the "Keymap" utility packaged as part of the NcDialogAPI distribution.       *
//*  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---   *
//*                                                                              *
//********************************************************************************
//* Programmer's Notes:                                                          *
//* - Translations listed in the ncurses header file ncurses.h are listed in     *
//*   OCTAL. We have no idea why, but we need not follow that foolishness here.  *
//*   The ncurses library defines a range of 64 keycodes:                        *
//*                     0400 through 0777   (octal)                              *
//*                   0x0100 through 0x01FF (hex)                                *
//*   - Cursor-movement keys.                                                    *
//*   - Screen formatting keys.                                                  *
//*   - Numeric keypad keys.                                                     *
//*   - The definition for four(4) sets of twelve(12) keycodes defining the      *
//*     various states of the first 12 function keys (see below).                *
//*   - Certain keycodes that will only be found on obsolete UNIX hardware.      *
//*   - Various special-purpose keycodes for reporting system events such as     *
//*     mouse movement.                                                          *
//*   The highest keycode actually defined is 0633(octal) == 0x019B with the     *
//*   remaining codes free for application-specific uses.                        *
//*                                                                              *
//*  The pseudo-key 0x0199 == KEY_MOUSE, is a signal that a mouse event          *
//*  has occurred.                                                               *
//*  The pseudo-key 0x019A == KEY_RESIZE, is a signal that a terminal window     *
//*  resize event has occurred.                                                  *
//*                                                                              *
//* -The ncurses library reserves 64 codes, 0x0108 through 0x0147 for            *
//*  translation of F-key (or other) escape sequences. This chart is for         *
//*  Wintel hardware. If you have a different keyboard layout, then there may    *
//*  be some differences in function-key definition.                             *
//*  KEY_F0 (keycode 0x0108) is reserved.                                        *
//*  12 are used for the FKey group            (0x0109-0x0114)                   *
//*  12 are used for the Shift+FKey group      (0x0115-0x0120)                   *
//*  12 are used for the Ctrl+FKey group       (0x0121-0x012C)                   *
//*  12 are used for the Ctrl+Shift+FKey group (0x012D-0x0138)                   *
//*  This leaves 15 codes for the NCurses class to use for other purposes.       *
//*                     0x0139 through 0x0147                                    *
//*  The NCurses class, at this time, defines only 0x0139 through 0x013D,        *
//*  used to define numeric keypad keys.                                         *
//*  Keycodes 0x013E-0x0147 are currently unassigned.                            *
//*                                                                              *
//* Keycodes beyond this range tend to be hardware-specific or OS-specific       *
//* (or affected by sunspots?). If portability is a primary concern for your     *
//* application, choose your group of user-interface keys carefully.             *
//*                                                                              *
//* Keycode definitions in the NCurses class are named according to the          *
//* following format:              nck[A][C][S]KEYNAME                           *
//*                                --- -  -  - -------                           *
//*                                 |  |  |  |  |                                *
//*    NCurses Key -----------------+  |  |  |  |                                *
//*    'A' if Alt key is used ---------+  |  |  |                                *
//*    'C' if Control key is used --------+  |  |                                *
//*    'S' if Shift key is ued --------------+  |                                *
//*    base key name ---------------------------+                                *
//*                                                                              *
//*  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - *
//*  Note on the wktEXTEND key type:                                             *
//*  This is an extension to the ncurses C-language library primitives.          *
//*  The GetKeyInput() method captures and translates the escape sequences       *
//*  representing the following key combinations.                                *
//*     'Alt + a'  through  'Alt + z'                                            *
//*       (returned as wkeyCode.type == wktEXTEND and  )                         *
//*       (            wkeyCode.key  == 'a'(nckA_A) through 'z'(nckA_Z))         *
//*       AND                                                                    *
//*     'Alt + Shift + a' through 'Alt + Shift + z'                              *
//*       (returned as wkeyCode.type == wktEXTEND and  )                         *
//*       (            wkeyCode.key  == 'A'(nckAS_A) through 'Z'(nckAS_Z))       *
//*       AND                                                                    *
//*     'Alt + 0'  through  'Alt + 9'                  AND                       *
//*     'Alt + Shift + 0'  through  'Alt + Shift + 9'  AND                       *
//*     'Alt + punctuation' AND 'Alt+Shift+punctuation'                          *
//*       (returned as wkeyCode.type == wktEXTEND and  )                         *
//*       (            wkeyCode.key  == corresponding character)                 *
//*       AND                                                                    *
//*     'Alt + Ctrl + a' through 'Alt + Ctrl + z'                                *
//*       (returned as wkeyCode.type == wktEXTEND and  )                         *
//*       (            wkeyCode.key  == 0x01(nckAC_Z) through 0x1A(nckAC_Z))     *
//*  Note: escape sequence for 'Shift+Ctrl+Alt+x' == 'Ctrl+Alt+x', so            *
//*        the 'Shift+Ctrl+Alt+...' group cannot be decoded independently.       *
//*                                                                              *
//*  Example:                                                                    *
//*  --------                                                                    *
//*  Because these keycodes are valid ONLY when the key type == wktEXTEND:       *
//*  wkeyCode  wk ;      // key-input class object                               *
//*  if ( (nc.GetKeyInput ( wk )) == wktEXTEND )                                 *
//*  {                                                                           *
//*     switch ( wk.key )                                                        *
//*     {                                                                        *
//*        case  nckA_A:  break ;   // this is Alt+a                             *
//*        case  nckAS_D: break ;   // this is Alt+Shift+d                       *
//*        case  nckAC_Z: break ;   // this is Alt+Ctrl+z                        *
//*     }                                                                        *
//*  }                                                                           *
//*                                                                              *
//* Note that keyboard escape sequences are system dependent. The keyboard       *
//* firmware in conjunction with the 'terminfo' (and the obsolete 'termcap')     *
//* databases determine key mapping, and the kernel I/O routines translate the   *
//* basic map, and the ncurses library translates additional escape sequences.   *
//* Therefore the wktEXTEND group is only certified for WinTel hardware.         *
//*  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - *
//*                                                                              *
//*                                                                              *
//*                                                                              *
//*                                                                              *
//********************************************************************************


//**************************************************************
//* Useful definitions for some of the non-printing characters *
//**************************************************************
// (See also GlobalDef.hpp)
const short nckNULLCHAR = 0x0000 ;     // NULL character (not a valid key code)
const short nckC_A      = 0x0001 ;     // ^A (Ctrl+A)
const short nckC_B      = 0x0002 ;     // ^B
const short nckC_C      = 0x0003 ;     // ^C
const short nckC_D      = 0x0004 ;     // ^D
const short nckC_E      = 0x0005 ;     // ^E
const short nckC_F      = 0x0006 ;     // ^F
const short nckC_G      = 0x0007 ;     // ^G
const short nckC_H      = 0x0008 ;     // ^H
const short nckTAB      = 0x0009 ;     // TAB key (^I)
const short nckENTER    = 0x000A ;     // Linefeed(^J),also Enter/Return(^M)
const short nckNEWLINE  = nckENTER ;
const short nckC_K      = 0x000B ;     // ^K
const short nckC_L      = 0x000C ;     // ^L
                       // 0x000D ;     // ^M (not used in Linux/Unix, see nckENTER)
const short nckC_N      = 0x000E ;     // ^N
const short nckC_O      = 0x000F ;     // ^O
const short nckC_P      = 0x0010 ;     // ^P
const short nckC_Q      = 0x0011 ;     // ^Q
const short nckC_R      = 0x0012 ;     // ^R
const short nckC_S      = 0x0013 ;     // ^S
const short nckC_T      = 0x0014 ;     // ^T
const short nckC_U      = 0x0015 ;     // ^U
const short nckC_V      = 0x0016 ;     // ^V
const short nckC_W      = 0x0017 ;     // ^W
const short nckC_X      = 0x0018 ;     // ^X
const short nckC_Y      = 0x0019 ;     // ^Y
const short nckC_Z      = 0x001A ;     // ^Z
const short nckESC      = 0x001B ;     // Escape key and ^[
const short nckC_4      = 0x001C ;     // ^4 and ^backslash
const short nckC_5      = 0x001D ;     // ^5 and ^] 
const short nckC_6      = 0x001E ;     // ^6 and ^^ 
const short nckC_7      = 0x001F ;     // ^7 and ^_ 

const wchar_t nckSPACE  = (SPACE) ;    // space key

//* Terminal resize event (0x019A).
//* When user drags the edges of the terminal window, this keycode is generated*
//* to alert the curses-based application that window size has changed.        *
const wchar_t nckRESIZE   = KEY_RESIZE ;


//** Conditional Compile:
//** (1) Use default keycode definitions.
//** (0) Use auto-generated custom keycode definitions.
#define DEFAULT_KEY_DEFINITIONS (1)

#if DEFAULT_KEY_DEFINITIONS == 0    // Custom Keycode Definitions
//*************************************************
//** Automatically-generated keycodes for key    **
//** combinations which may be system dependent. **
//**      See "Keymap" utility for details.      **
//*************************************************
#include "NCursesKeyDef_auto.hpp"


#else    // DEFAULT_KEYCODE_DEFINITIONS == (1)
//*********** Navigation key group (52 keycodes) ***********
//            Key Name       Keycode    Key Esc Sequence (hex)  Key Combination
//            -----------    --------   ----------------------  ---------------------------
// Generated by Keymap v:0.0.06 , NcDialogAPI v:0.0.37 , ncursesw link library v:6.4.20230520
const wchar_t nckUP        = 0x0103 ;  // 1B 5B 41              (UpArrow)
const wchar_t nckSUP       = 0x0151 ;  // 1B 5B 31 3B 32 41     (Shift+UpArrow)
const wchar_t nckAUP       = 0x023D ;  // 1B 5B 31 3B 33 41     (Alt+UpArrow)
const wchar_t nckASUP      = 0x023E ;  // 1B 5B 31 3B 34 41     (Alt+Shift+UpArrow)
const wchar_t nckCUP       = 0x023F ;  // 1B 5B 31 3B 35 41     (Ctrl+UpArrow)
const wchar_t nckCSUP      = 0x0240 ;  // 1B 5B 31 3B 36 41     (Ctrl+Shift+UpArrow)
const wchar_t nckACUP      = 0x0241 ;  // 1B 5B 31 3B 37 41     (Alt+Ctrl+UpArrow) (Wayland "workspace-up")

const wchar_t nckDOWN      = 0x0102 ;  // 1B 5B 42              (DownArrow)
const wchar_t nckSDOWN     = 0x0150 ;  // 1B 5B 31 3B 32 42     (Shift+DownArrow)
const wchar_t nckADOWN     = 0x0214 ;  // 1B 5B 31 3B 33 42     (Alt+DownArrow)
const wchar_t nckASDOWN    = 0x0215 ;  // 1B 5B 31 3B 34 42     (Alt+Shift+DownArrow)
const wchar_t nckCDOWN     = 0x0216 ;  // 1B 5B 31 3B 35 42     (Ctrl+DownArrow)
const wchar_t nckCSDOWN    = 0x0217 ;  // 1B 5B 31 3B 36 42     (Ctrl+Shift+DownArrow)
const wchar_t nckACDOWN    = 0x0218 ;  // 1B 5B 31 3B 37 42     (Alt+Ctrl+DownArrow) (Wayland "workspace-down")

const wchar_t nckLEFT      = 0x0104 ;  // 1B 5B 44              (LeftArrow)
const wchar_t nckSLEFT     = 0x0189 ;  // 1B 5B 31 3B 32 44     (Shift+LeftArrow)
const wchar_t nckALEFT     = 0x0228 ;  // 1B 5B 31 3B 33 44     (Alt+LeftArrow)
const wchar_t nckASLEFT    = 0x0229 ;  // 1B 5B 31 3B 34 44     (Alt+Shift+LeftArrow)
const wchar_t nckCLEFT     = 0x022A ;  // 1B 5B 31 3B 35 44     (Ctrl+LeftArrow)
const wchar_t nckCSLEFT    = 0x022B ;  // 1B 5B 31 3B 36 44     (Ctrl+Shift+LeftArrow)
const wchar_t nckACLEFT    = 0x022C ;  // 1B 5B 31 3B 37 44     (Alt+Ctrl+LeftArrow)

const wchar_t nckRIGHT     = 0x0105 ;  // 1B 5B 43              (RightArrow)
const wchar_t nckSRIGHT    = 0x0192 ;  // 1B 5B 31 3B 32 43     (Shift+RightArrow)
const wchar_t nckARIGHT    = 0x0237 ;  // 1B 5B 31 3B 33 43     (Alt+RightArrow)
const wchar_t nckASRIGHT   = 0x0238 ;  // 1B 5B 31 3B 34 43     (Alt+Shift+RightArrow)
const wchar_t nckCRIGHT    = 0x0239 ;  // 1B 5B 31 3B 35 43     (Ctrl+RightArrow)
const wchar_t nckCSRIGHT   = 0x023A ;  // 1B 5B 31 3B 36 43     (Ctrl+Shift+RightArrow)
const wchar_t nckACRIGHT   = 0x023B ;  // 1B 5B 31 3B 37 43     (Alt+Ctrl+RightArrow)

const wchar_t nckPGUP      = 0x0153 ;  // 1B 5B 35 7E           (PageUp)
const wchar_t nckSPGUP     = 0x018E ;  // 1B 5B 35 3B 32 7E     (Shift+PageUp)
const wchar_t nckAPGUP     = 0x0232 ;  // 1B 5B 35 3B 33 7E     (Alt+PageUp)
const wchar_t nckASPGUP    = 0x0233 ;  // 1B 5B 35 3B 34 7E     (Alt+Shift+PageUp)
const wchar_t nckACPGUP    = 0x0236 ;  // 1B 5B 35 3B 37 7E     (Alt+Ctrl+PageUp)

const wchar_t nckPGDOWN    = 0x0152 ;  // 1B 5B 36 7E           (PageDown)
const wchar_t nckSPGDN     = 0x018C ;  // 1B 5B 36 3B 32 7E     (Shift+PageDown)
const wchar_t nckAPGDN     = 0x022D ;  // 1B 5B 36 3B 33 7E     (Alt+PageDown)
const wchar_t nckASPGDN    = 0x022E ;  // 1B 5B 36 3B 34 7E     (Alt+Shift+PageDown)
const wchar_t nckACPGDN    = 0x0231 ;  // 1B 5B 36 3B 37 7E     (Alt+Ctrl+PageDown)

const wchar_t nckHOME      = 0x0106 ;  // 1B 5B 48              (Home)
const wchar_t nckSHOME     = 0x0187 ;  // 1B 5B 31 3B 32 48     (Shift+Home)
const wchar_t nckAHOME     = 0x021E ;  // 1B 5B 31 3B 33 48     (Alt+Home)
const wchar_t nckASHOME    = 0x021F ;  // 1B 5B 31 3B 34 48     (Alt+Shift+Home)
const wchar_t nckCHOME     = 0x0220 ;  // 1B 5B 31 3B 35 48     (Ctrl+Home)
const wchar_t nckCSHOME    = 0x0221 ;  // 1B 5B 31 3B 36 48     (Ctrl+Shift+Home)
const wchar_t nckACHOME    = 0x0222 ;  // 1B 5B 31 3B 37 48     (Alt+Ctrl+Home)

const wchar_t nckEND       = 0x0168 ;  // 1B 5B 46              (End)
const wchar_t nckSEND      = 0x0182 ;  // 1B 5B 31 3B 32 46     (Shift+End)
const wchar_t nckAEND      = 0x0219 ;  // 1B 5B 31 3B 33 46     (Alt+End)
const wchar_t nckASEND     = 0x021A ;  // 1B 5B 31 3B 34 46     (Alt+Shift+End)
const wchar_t nckCEND      = 0x021B ;  // 1B 5B 31 3B 35 46     (Ctrl+End)
const wchar_t nckCSEND     = 0x021C ;  // 1B 5B 31 3B 36 46     (Ctrl+Shift+End)
const wchar_t nckACEND     = 0x021D ;  // 1B 5B 31 3B 37 46     (Alt+Ctrl+End)

//*********** Function key group (48 keycodes) ***********
//            Key Name       Keycode    Key Esc Sequence (hex)  Key Combination
//            -----------    --------   ----------------------  ---------------------------
const wchar_t nckF01       = 0x0109 ;  // 1B 4F 50              (F01)
const wchar_t nckF02       = 0x010A ;  // 1B 4F 51              (F02)
const wchar_t nckF03       = 0x010B ;  // 1B 4F 52              (F03)
const wchar_t nckF04       = 0x010C ;  // 1B 4F 53              (F04)
const wchar_t nckF05       = 0x010D ;  // 1B 5B 31 35 7E        (F05)
const wchar_t nckF06       = 0x010E ;  // 1B 5B 31 37 7E        (F06)
const wchar_t nckF07       = 0x010F ;  // 1B 5B 31 38 7E        (F07)
const wchar_t nckF08       = 0x0110 ;  // 1B 5B 31 39 7E        (F08)
const wchar_t nckF09       = 0x0111 ;  // 1B 5B 32 30 7E        (F09)
const wchar_t nckF10       = 0x0112 ;  // 1B 5B 32 31 7E        (F10)
const wchar_t nckF11       = 0x0113 ;  // 1B 5B 32 33 7E        (F11)
const wchar_t nckF12       = 0x0114 ;  // 1B 5B 32 34 7E        (F12)

const wchar_t nckSF01      = 0x0115 ;  // 1B 5B 31 3B 32 50     (Shift+F01)
const wchar_t nckSF02      = 0x0116 ;  // 1B 5B 31 3B 32 51     (Shift+F02)
const wchar_t nckSF03      = 0x0117 ;  // 1B 5B 31 3B 32 52     (Shift+F03)
const wchar_t nckSF04      = 0x0118 ;  // 1B 5B 31 3B 32 53     (Shift+F04)
const wchar_t nckSF05      = 0x0119 ;  // 1B 5B 31 35 3B 32 7E  (Shift+F05)
const wchar_t nckSF06      = 0x011A ;  // 1B 5B 31 37 3B 32 7E  (Shift+F06)
const wchar_t nckSF07      = 0x011B ;  // 1B 5B 31 38 3B 32 7E  (Shift+F07)
const wchar_t nckSF08      = 0x011C ;  // 1B 5B 31 39 3B 32 7E  (Shift+F08)
const wchar_t nckSF09      = 0x011D ;  // 1B 5B 32 30 3B 32 7E  (Shift+F09)
const wchar_t nckSF10      = 0x011E ;  // 1B 5B 32 31 3B 32 7E  (Shift+F10)
const wchar_t nckSF11      = 0x011F ;  // 1B 5B 32 33 3B 32 7E  (Shift+F11)
const wchar_t nckSF12      = 0x0120 ;  // 1B 5B 32 34 3B 32 7E  (Shift+F12)

const wchar_t nckCF01      = 0x0121 ;  // 1B 5B 31 3B 35 50     (Ctrl+F01)
const wchar_t nckCF02      = 0x0122 ;  // 1B 5B 31 3B 35 51     (Ctrl+F02)
const wchar_t nckCF03      = 0x0123 ;  // 1B 5B 31 3B 35 52     (Ctrl+F03)
const wchar_t nckCF04      = 0x0124 ;  // 1B 5B 31 3B 35 53     (Ctrl+F04)
const wchar_t nckCF05      = 0x0125 ;  // 1B 5B 31 35 3B 35 7E  (Ctrl+F05)
const wchar_t nckCF06      = 0x0126 ;  // 1B 5B 31 37 3B 35 7E  (Ctrl+F06)
const wchar_t nckCF07      = 0x0127 ;  // 1B 5B 31 38 3B 35 7E  (Ctrl+F07)
const wchar_t nckCF08      = 0x0128 ;  // 1B 5B 31 39 3B 35 7E  (Ctrl+F08)
const wchar_t nckCF09      = 0x0129 ;  // 1B 5B 32 30 3B 35 7E  (Ctrl+F09)
const wchar_t nckCF10      = 0x012A ;  // 1B 5B 32 31 3B 35 7E  (Ctrl+F10)
const wchar_t nckCF11      = 0x012B ;  // 1B 5B 32 33 3B 35 7E  (Ctrl+F11)
const wchar_t nckCF12      = 0x012C ;  // 1B 5B 32 34 3B 35 7E  (Ctrl+F12)

const wchar_t nckCSF01     = 0x012D ;  // 1B 5B 31 3B 36 50     (Ctrl+Shift+F01)
const wchar_t nckCSF02     = 0x012E ;  // 1B 5B 31 3B 36 51     (Ctrl+Shift+F02)
const wchar_t nckCSF03     = 0x012F ;  // 1B 5B 31 3B 36 52     (Ctrl+Shift+F03)
const wchar_t nckCSF04     = 0x0130 ;  // 1B 5B 31 3B 36 53     (Ctrl+Shift+F04)
const wchar_t nckCSF05     = 0x0131 ;  // 1B 5B 31 35 3B 36 7E  (Ctrl+Shift+F05)
const wchar_t nckCSF06     = 0x0132 ;  // 1B 5B 31 37 3B 36 7E  (Ctrl+Shift+F06)
const wchar_t nckCSF07     = 0x0133 ;  // 1B 5B 31 38 3B 36 7E  (Ctrl+Shift+F07)
const wchar_t nckCSF08     = 0x0134 ;  // 1B 5B 31 39 3B 36 7E  (Ctrl+Shift+F08)
const wchar_t nckCSF09     = 0x0135 ;  // 1B 5B 32 30 3B 36 7E  (Ctrl+Shift+F09)
const wchar_t nckCSF10     = 0x0136 ;  // 1B 5B 32 31 3B 36 7E  (Ctrl+Shift+F10)
const wchar_t nckCSF11     = 0x0137 ;  // 1B 5B 32 33 3B 36 7E  (Ctrl+Shift+F11)
const wchar_t nckCSF12     = 0x0138 ;  // 1B 5B 32 34 3B 36 7E  (Ctrl+Shift+F12)

//*********** Keypad key group (54 keycodes) ***********
//            Key Name       Keycode    Key Esc Sequence (hex)  Key Combination
//            -----------    --------   ----------------------  ---------------------------
// Generated by Keymap v:0.0.06 , NcDialogAPI v:0.0.37 , ncursesw link library v:6.4.20230520
const wchar_t nckpCENTER   = 0x0162 ;  // 1B 5B 45              (keypad Center)
const wchar_t nckpUP       = 0x0103 ;  // 1B 5B 41              (keypad UpArrow)
const wchar_t nckpAUP      = 0x023D ;  // 1B 5B 31 3B 33 41     (keypad Alt+UpArrow)
const wchar_t nckpCUP      = 0x023F ;  // 1B 5B 31 3B 35 41     (keypad Ctrl+UpArrow)
const wchar_t nckpACUP     = 0x0241 ;  // 1B 5B 31 3B 37 41     (keypad Alt+Ctrl+Up)

const wchar_t nckpDOWN     = 0x0102 ;  // 1B 5B 42              (keypad DownArrow)
const wchar_t nckpADOWN    = 0x0214 ;  // 1B 5B 31 3B 33 42     (keypad Alt+DownArrow)
const wchar_t nckpCDOWN    = 0x0216 ;  // 1B 5B 31 3B 35 42     (keypad Ctrl+DownArrow)
const wchar_t nckpACDOWN   = 0x0218 ;  // 1B 5B 31 3B 37 42     (keypad Alt+Ctrl+Down)

const wchar_t nckpLEFT     = 0x0104 ;  // 1B 5B 44              (keypad LeftArrow)
const wchar_t nckpALEFT    = 0x0228 ;  // 1B 5B 31 3B 33 44     (keypad Alt+LeftArrow)
const wchar_t nckpCLEFT    = 0x022A ;  // 1B 5B 31 3B 35 44     (keypad Ctrl+LeftArrow)
const wchar_t nckpACLEFT   = 0x022C ;  // 1B 5B 31 3B 37 44     (keypad Alt+Ctrl+Left)

const wchar_t nckpRIGHT    = 0x0105 ;  // 1B 5B 43              (keypad RightArrow)
const wchar_t nckpARIGHT   = 0x0237 ;  // 1B 5B 31 3B 33 43     (keypad Alt+RightArrow)
const wchar_t nckpCRIGHT   = 0x0239 ;  // 1B 5B 31 3B 35 43     (keypad Ctrl+RightArrow)
const wchar_t nckpACRIGHT  = 0x023B ;  // 1B 5B 31 3B 37 43     (keypad Alt+Ctrl+Right)

const wchar_t nckpINSERT   = 0x014B ;  // 1B 5B 32 7E           (keypad Insert)
const wchar_t nckpAINSERT  = 0x0223 ;  // 1B 5B 32 3B 33 7E     (keypad Alt+Insert)
const wchar_t nckpDELETE   = 0x014A ;  // 1B 5B 33 7E           (keypad Delete)
const wchar_t nckpADEL     = 0x020E ;  // 1B 5B 33 3B 33 7E     (keypad Alt+Delete)
const wchar_t nckpCDEL     = 0x0210 ;  // 1B 5B 33 3B 35 7E     (keypad Ctrl+Delete)
const wchar_t nckpACDEL    = 0x0212 ;  // 1B 5B 33 3B 37 7E     (keypad Alt+Ctrl+Delete)

const wchar_t nckpPGUP     = 0x0153 ;  // 1B 5B 35 7E           (keypad PageUp)
const wchar_t nckpAPGUP    = 0x0232 ;  // 1B 5B 35 3B 33 7E     (keypad Alt+PageUp)
const wchar_t nckpCPGUP    = 0x0234 ;  // 1B 5B 35 3B 35 7E     (keypad Ctrl+PageUp)
const wchar_t nckpACPGUP   = 0x0236 ;  // 1B 5B 35 3B 37 7E     (keypad Alt+Ctrl+PageUp)
const wchar_t nckpPGDN     = 0x0152 ;  // 1B 5B 36 7E           (keypad PageDown)
const wchar_t nckpAPGDN    = 0x022D ;  // 1B 5B 36 3B 33 7E     (keypad Alt+PageDown)
const wchar_t nckpCPGDN    = 0x022F ;  // 1B 5B 36 3B 35 7E     (keypad Ctrl+PageDown)
const wchar_t nckpACPGDN   = 0x0231 ;  // 1B 5B 36 3B 37 7E     (keypad Alt+Ctrl+PageDown)

const wchar_t nckpHOME     = 0x0106 ;  // 1B 5B 48              (keypad Home)
const wchar_t nckpAHOME    = 0x021E ;  // 1B 5B 31 3B 33 48     (keypad Alt+Home)
const wchar_t nckpCHOME    = 0x0220 ;  // 1B 5B 31 3B 35 48     (keypad Ctrl+Home)
const wchar_t nckpACHOME   = 0x0222 ;  // 1B 5B 31 3B 37 48     (keypad Alt+Ctrl+Home)

const wchar_t nckpEND      = 0x0168 ;  // 1B 5B 46              (keypad End)
const wchar_t nckpAEND     = 0x0219 ;  // 1B 5B 31 3B 33 46     (keypad Alt+End)
const wchar_t nckpCEND     = 0x021B ;  // 1B 5B 31 3B 35 46     (keypad Ctrl+End)
const wchar_t nckpACEND    = 0x021D ;  // 1B 5B 31 3B 37 46     (keypad Alt+Ctrl+End)

const wchar_t nckpPLUS     = 0x0247 ;  // '+'                   (keypad Plus)
const wchar_t nckpMINUS    = 0x024C ;  // '-'                   (keypad Minus)
const wchar_t nckpMULT     = 0x024B ;  // '*'                   (keypad Multiply)
const wchar_t nckpDIV      = 0x0249 ;  // '/'                   (keypad Divide)

const wchar_t nckINSERT    = 0x014B ;  // 1B 5B 32 7E           (Insert key (main keybrd))
const wchar_t nckAINSERT   = 0x0223 ;  // 1B 5B 32 3B 33 7E     (Alt+Insert)
const wchar_t nckDELETE    = 0x014A ;  // 1B 5B 33 7E           (Delete key (main keybrd))
const wchar_t nckSDEL      = 0x017F ;  // 1B 5B 33 3B 32 7E     (Shift+Delete)
const wchar_t nckADEL      = 0x020E ;  // 1B 5B 33 3B 33 7E     (Alt+Delete)
const wchar_t nckASDEL     = 0x020F ;  // 1B 5B 33 3B 34 7E     (Alt+Shift+Delete)
const wchar_t nckCDEL      = 0x0210 ;  // 1B 5B 33 3B 35 7E     (Ctrl+Delete)
const wchar_t nckCSDEL     = 0x0211 ;  // 1B 5B 33 3B 36 7E     (Ctrl+Shift+Delete)
const wchar_t nckBKSP      = 0x0107 ;  // '0x7F' (ASCII Delete) (Backspace)
const wchar_t nckSTAB      = 0x0161 ;  // 1B 5B 5A              (Shift+Tab)
const wchar_t nckpENTER    = 0x0157 ;  // '0x0A' (ASCII Enter)  (keypad Enter)

#endif   // DEFAULT_KEYCODE_DEFINITIONS


//* These codes remain available for assignment within the wktFUNKEY group.*
//const wchar_t nckUNASSIGNED = 0x013E ;   // (octal 0476)
//const wchar_t nckUNASSIGNED = 0x013F ;   // 
//const wchar_t nckUNASSIGNED = 0x0140 ;   // 
//const wchar_t nckUNASSIGNED = 0x0141 ;   // 
//const wchar_t nckUNASSIGNED = 0x0142 ;   // 
//const wchar_t nckUNASSIGNED = 0x0143 ;   // 
//const wchar_t nckUNASSIGNED = 0x0144 ;   // 
//const wchar_t nckUNASSIGNED = 0x0145 ;   // 
//const wchar_t nckUNASSIGNED = 0x0146 ;   // 
//const wchar_t nckUNASSIGNED = 0x0147 ;   // (octal 0507)


//* wktEXTEND group of keycode definitions.                                    *
//* These keycodes are valid ONLY if key type == wktEXTEND. See example in     *
//* module header above.                                                       *
const short nckA_A      = 'a' ;
const short nckA_B      = 'b' ;
const short nckA_C      = 'c' ;
const short nckA_D      = 'd' ;
const short nckA_E      = 'e' ;
const short nckA_F      = 'f' ;
const short nckA_G      = 'g' ;
const short nckA_H      = 'h' ;
const short nckA_I      = 'i' ;
const short nckA_J      = 'j' ;
const short nckA_K      = 'k' ;
const short nckA_L      = 'l' ;
const short nckA_M      = 'm' ;
const short nckA_N      = 'n' ;
const short nckA_O      = 'o' ;
const short nckA_P      = 'p' ;
const short nckA_Q      = 'q' ;
const short nckA_R      = 'r' ;
const short nckA_S      = 's' ;
const short nckA_T      = 't' ;
const short nckA_U      = 'u' ;
const short nckA_V      = 'v' ;
const short nckA_W      = 'w' ;
const short nckA_X      = 'x' ;
const short nckA_Y      = 'y' ;
const short nckA_Z      = 'z' ;

const short nckA_0      = '0' ;     // this group may be captured by the terminal
const short nckA_1      = '1' ;     // ...
const short nckA_2      = '2' ;     // ...
const short nckA_3      = '3' ;     // ...
const short nckA_4      = '4' ;     // ...
const short nckA_5      = '5' ;     // ...
const short nckA_6      = '6' ;     // ...
const short nckA_7      = '7' ;     // ...
const short nckA_8      = '8' ;     // ...
const short nckA_9      = '9' ;     // ...

const short nckAS_A     = 'A' ;
const short nckAS_B     = 'B' ;
const short nckAS_C     = 'C' ;
const short nckAS_D     = 'D' ;
const short nckAS_E     = 'E' ;
const short nckAS_F     = 'F' ;
const short nckAS_G     = 'G' ;
const short nckAS_H     = 'H' ;
const short nckAS_I     = 'I' ;
const short nckAS_J     = 'J' ;
const short nckAS_K     = 'K' ;
const short nckAS_L     = 'L' ;
const short nckAS_M     = 'M' ;
const short nckAS_N     = 'N' ;
const short nckAS_O     = 'O' ;
const short nckAS_P     = 'P' ;
const short nckAS_Q     = 'Q' ;
const short nckAS_R     = 'R' ;
const short nckAS_S     = 'S' ;
const short nckAS_T     = 'T' ;
const short nckAS_U     = 'U' ;
const short nckAS_V     = 'V' ;
const short nckAS_W     = 'W' ;
const short nckAS_X     = 'X' ;
const short nckAS_Y     = 'Y' ;
const short nckAS_Z     = 'Z' ;

const short nckAS_0     = ')' ;
const short nckAS_1     = '!' ;
const short nckAS_2     = '@' ;
const short nckAS_3     = '#' ;
const short nckAS_4     = '$' ;
const short nckAS_5     = '%' ;
const short nckAS_6     = '^' ;
const short nckAS_7     = '&' ;
const short nckAS_8     = '*' ;
const short nckAS_9     = '(' ;

const short nckAS_SPC   = ' ' ;  // NOTE: multiple key combinations yield this code
const short nckA_DQUO   = '"' ;
const short nckA_SQUO   = '\'' ;
const short nckA_PLUS   = '+' ;
const short nckA_COMM   = ',' ;
const short nckA_MINU   = '-' ;
const short nckA_STOP   = '.' ;
const short nckA_FSTR   = '/' ;
const short nckA_COLO   = ':' ;
const short nckA_SEMI   = ';' ;
const short nckA_LCHV   = '<' ;
const short nckA_EQUL   = '=' ;
const short nckA_RCHV   = '>' ;
const short nckA_QUES   = '?' ;
const short nckA_LBRK   = '[' ;
const short nckA_BSTR   = '\\' ;
const short nckA_RBRK   = ']' ;
const short nckA_UNDR   = '_' ;
const short nckA_GRAV   = '`' ;
const short nckA_LBRC   = '{' ;
const short nckA_VBAR   = '|' ;
const short nckA_RBRC   = '}' ;
const short nckA_TILD   = '~' ;

const short nckAC_A     = 0x01 ;
const short nckAC_B     = 0x02 ;
const short nckAC_C     = 0x03 ;
const short nckAC_D     = 0x04 ;
const short nckAC_E     = 0x05 ;
const short nckAC_F     = 0x06 ;
const short nckAC_G     = 0x07 ;
const short nckAC_H     = 0x08 ;
const short nckAC_I     = 0x09 ;
const short nckAC_J     = 0x0A ;
const short nckAC_K     = 0x0B ;
const short nckAC_L     = 0x0C ;
const short nckAC_M     = 0x0D ;
const short nckAC_N     = 0x0E ;
const short nckAC_O     = 0x0F ;
const short nckAC_P     = 0x10 ;
const short nckAC_Q     = 0x11 ;
const short nckAC_R     = 0x12 ;
const short nckAC_S     = 0x13 ;
const short nckAC_T     = 0x14 ;
const short nckAC_U     = 0x15 ;
const short nckAC_V     = 0x16 ;
const short nckAC_W     = 0x17 ;
const short nckAC_X     = 0x18 ;
const short nckAC_Y     = 0x19 ;
const short nckAC_Z     = 0x1A ;

