#!/usr/bin/perl
# Uninstall the FileMangler docs from the info reader database. #
use strict ;
use warnings ;

   my $FMGlocdir  = "/usr/local/share/info" ;   # documentation target directory (local)
   my $FMGloctrg  = "$FMGlocdir/dir" ;          # documentation target database  (local)
   my $FMGglodir  = "/usr/share/info" ;         # documentation target directory (global)
   my $FMGglotrg  = "$FMGglodir/dir" ;          # documentation target database  (global)
   my $FMGinfodir = "" ;
   my $FMGinfotrg = "" ;

   print "\n** Uninstall the Texinfo Documentation. **" ;
   print "\n**   (requires super-user privelege)    **\n" ;

   if ( -e $FMGloctrg )                      # Find the database file
   {
      $FMGinfotrg = "$FMGloctrg" ;
      $FMGinfodir = "$FMGlocdir" ;
   }
   elsif ( -e $FMGglotrg )
   {
      $FMGinfotrg = "$FMGglotrg" ;
      $FMGinfodir = "$FMGglodir" ;
   }

   if ( "$FMGinfotrg" ne "" )                # If database file found
   {
      print "\nTexinfo top-level database: $FMGinfotrg\n" ;
   }
   use Cwd qw ( getcwd ) ;
   chdir ( "$FMGinfodir" ) ;
   my $WD=getcwd() ;

   system ( "grep -C1 'FileMangler' '$FMGinfotrg'" ) ;
   print "\n" ;

   if ( $WD ne $FMGinfodir )
   {
      print "Unable to reach '$FMGinfodir' directory.\n\n" ;
      exit ;
   }

   system ( "sudo install-info --dir-file=dir --info-file=filemangler.info --name=FileMangler --remove --debug" );

   system ( "grep -C1 'FileMangler' '$FMGinfotrg'" ) ;

   print "\n\n" ;
