#!/bin/bash
# *****************************************************************
# Invoke FileMangler as Superuser, i.e. FileMangler(root)         *
# When logged in as 'root' or invoking through 'sudo', the        *
# superuser's $HOME == /root ; and also, some needed libraries may*
# not be in default locations where the root user can find them.  *
#                                                                 *
#                       IMPORTANT NOTE:                           *
#                       ===============                           *
# Set the environment variables below to reference the directory  *
# where you installed the FileMangler binaries and the config file*
# modified for the superuser (see below), then:                   *
#                                                                 *
#        It is recommended that this file be placed in:           *
#                   /usr/local/sbin                               *
#        which should always be on the superuser's $PATH.         *
#                                                                 *
#        Invoke using: sudo fmgr.sh                               *
#           (then enter password when prompted)                   *
#                                                                 *
# Limitations:                                                    *
# ------------                                                    *
# Note that the application's file management tools are fully     *
# functional when invoked as the superuser, but the auxilliary    *
# operations described here may not be available in superuser     *
# mode. (Sorry about that...)                                     *
#                                                                 *
# 1) When invoked as the superuser: "sudo fmgr.sh"                *
#    FileMangler may not be able to find the Trashcan. For this   *
#    reason, it is necessary to explicitly declare the location   *
#    of the Trashcan. When FileMangler is invoked through this    *
#    bash shell script the invocation specifies a special purpose *
#    copy of the configuration file which specifies the absolute  *
#    path of the desired Trashcan.                                *
#    Example: /home/sam/.local/share/Trash                        *
#    See documentation for a description of the FileMangler       *
#    configuration file.                                          *
# 2) When invoked as the superuser, FileMangler's access to the   *
#    Wayland system clipboard via the wl-clipboard utilities is   *
#    not available by default because the superuser does not have *
#    access to the (user-owned) wl-copy/wl-paste communications   *
#    socket.                                                      *
#    -- This socket is _probably_ located at:                     *
#         /run/user/1000/wayland-0                                *
#    -- Superuser expects to find it at: /run/user/0/wayland-0    *
#    -- Creating a symlink file at the expected location makes    *
#       the socket visible and the clipboard accessible; however, *
#       this is a dynamic directory, and the symlink may disappear*
#       at any time.                                              *
#       -- Note that it may be necessary to modify permissions on *
#          the socket by enabling write access for 'group'.       *
#    Note that the application's file management tools are fully  *
#    functional even without the system clipboard, so this        *
#    limitation should be only a minor issue.                     *
# 3) When this bash script is executed directly, the ability to   *
#    exit the application to a new target directory is not        *
#    available because the script is executed in a child process  *
#    which for technical reasons does not communicate with the    *
#    primary process. For a standard-privilege user, this can be  *
#    overcome by using the bash built-in command, 'source'.       *
#    Example: source 'fmg.sh'                                     *
#    -- Unfortunately, the bash 'source' command and the 'sudo'   *
#       sys-admin command do not recognize each other; therefore, *
#       neither of the following are valid constructs:            *
#           sudo source 'fmgr.sh'  or                             *
#           source sudo 'fmgr.sh'                                 *
#    Even though this script supports the alternate exit target,  *
#    the superuser's inability to invoke using the primary process*
#    will cause the application to always exit to the directory   *
#    from which it was invoked.                                   *
# *****************************************************************

# A) Create and export environment variables for 
#    communication with the target application.
export LD_LIBRARY_PATH=/usr/lib64:/usr/lib:/lib
export FMG_HOME="/home/sam/Apps/FileMangler"
export FMG_CONFIG="$FMG_HOME/fmSuperman.cfg"
export FMG_WD_FILE="$(mktemp --tmpdir FMG.XXX)"    # unique temporary file

# B) Establish the set of recognized exit codes:
FMG_ORIG_WD=0
FMG_CURR_WD=2

# C) Invoke the application:
"$FMG_HOME"/FileMangler -f="$FMG_CONFIG" $1 $2 $3 $4 $5 $6

# D) Check the application's exit code for exit to alternate directory.
FMG_EXIT="$?"                                # get exit code
if [ -f $FMG_WD_FILE ] ; then                # test existence of temp file
   if [ $FMG_EXIT -eq $FMG_CURR_WD ] ; then  # test return value
      cd "$(cat $FMG_WD_FILE)"               # change directory
   fi
   rm $FMG_WD_FILE                           # delete the temp file
fi
