//********************************************************************************
//* BubbleSort.hpp                                                               *
//* Author     : Mahlon R. Smith                                                 *
//*              Copyright (c) 2025 Mahlon R. Smith, The Software Samurai        *
//*                  GNU GPL copyright notice located in FileMangler.hpp         *
//* Date       : 19-Feb-2025                                                     *
//* Version    : (see appVersion, below)                                         *
//*                                                                              *
//* Description:                                                                 *
//* BubbSort class definition.                                                   *
//* Perform a bidirectional bubble sort on a randomized array of strings or      *
//* a randomized array of integer values.                                        *
//*                                                                              *
//********************************************************************************

//*****************
//* Include Files *
//*****************
#include <unistd.h>                 // UNIX/Linux system interface
#include <iostream>                 // standard I/O definitions
#include <fstream>                  // file I/O
#include <cstdlib>                  // misc. functionality
#include <locale>                   // support for locale-specific comparisons
#include "gString.hpp"              // gString class definition
using namespace std;

//***************
//* Definitions *
//***************
const char* const titleTemplate = 
            "BubbleSort (bubsort) v:%s Copyright (c) %s The Software Samurai\n" ;
const char* const appVersion = "0.0.03" ;
const char* const appYears   = "2025 - ____" ;
const char* const freeSoftware = 
"License GPLv3+: GNU GPL version 3 <http://gnu.org/licenses/gpl.html>\n"
"This is free software: you are free to modify and/or redistribute it\n"
"under the terms set out in the license.\n"
"There is NO WARRANTY, to the extent permitted by law.\n\n" ;
const int   ZERO = (0) ;
const int   NEWLINE = L'\n' ;

enum srcType : short
{
   tpSptr,     // source : pointers to text strings
   tpStxt,     // source : text strings
   tpAptr,     // source : pointers to alternate-text
   tpAtxt,     // source : alternate-text strings
   tpInt,      // source : integer data
   tpRptr,     // source : pointers to WinPos-class data
   tpRrec,     // source : WinPos-class data records
   tpColl,     // source : pointers to text strings (collate algorithm)
   tpFile      // source : text data from specified external file
} ;

//* This is a simplified version of a small class used in many *
//* of our other applications. In this demonstration app, it   *
//* is used to demonstrate sorting of complex objects, both    *
//* via pointers and by direct sort. Direct sorting of complex *
//* objects is not recommended because it tends to be very     *
//* slow. (see note in .cpp module).                           *
class WinPos
{
   public:
   //* Default constructor *
   WinPos ( void ) { row = 0 ; col = 0 ; }

   //* Initialization constructor *
   WinPos( const short& rval, const short& cval ) : row(rval), col(cval) {}

   void reset ( void ) { this->row = this->col = 0 ; }

   bool operator == ( const WinPos& wp )
   {
      bool eq = false ;
      if ( (wp.row == this->row) && (wp.col == this->col) ) { eq = true ; }
      return eq ;
   }
   bool operator != ( const WinPos& wp )
   {
      bool eq = false ;
      if ( (wp.row != this->row) || (wp.col != this->col) ) { eq = true ; }
      return eq ;
   }
   void operator = ( const WinPos& wpA )
   { this->row = wpA.row ; this->col = wpA.col ; }
   void operator += ( const WinPos& wpA )
   { this->row += wpA.row ; this->col += wpA.col ; }

   //* Public data members *
   short row ;                // Row number    (offset)
   short col ;                // Column number (offset)
} ;   // WinPos

static const int recLENGTH  = 64 ;  // buffer size for string test data record
static const int srcRECORDS = 10 ;  // number of test records of each type


class BubbSort
{
   public:
   ~BubbSort ( void )         // destructor
   {
      if ( this->extData != NULL )  // release dynamic allocations
         delete [] this->extData ;
      if ( this->extDPtr != NULL )
         delete [] this->extDPtr ;
   }
   BubbSort ( void )          // default constructor (not used)
   { return ; }

   BubbSort ( int argc, char* argv[], char* argenv[] ) ; // initialization constructor

   //* Sort sample data *
   void  SortLow2HighTextPointer ( wchar_t** src, int recs ) ;
   void  SortHigh2LowTextPointer ( wchar_t** src, int recs ) ;
   void  SortLow2HighTextDirect ( wchar_t src[][recLENGTH], int recs ) ;
   void  SortHigh2LowTextDirect ( wchar_t src[][recLENGTH], int recs ) ;
   void  SortLow2HighInteger ( int* src, int recs ) ;
   void  SortHigh2LowInteger ( int* src, int recs ) ;
   void  SortLow2HighRecordPointer ( WinPos** src, int recs ) ;
   void  SortHigh2LowRecordPointer ( WinPos** src, int recs ) ;
   void  SortLow2HighRecords ( WinPos* src, int recs ) ;
   void  SortHigh2LowRecords ( WinPos* src, int recs ) ;

   //* Sort external record data *
   bool  SortExternalRecords ( void ) ;
   bool  VerifySourceFile ( const gString& fname ) ;

   //* Utility Methods *
   bool  GetCommlineArgs ( int argc, char* argv[], char* argenv[] ) ;
   void  SetLocale ( void ) ; // initialize "locale" from the environment
   void  Version ( void ) ;   // report application version
   void  Help ( void ) ;      // report application help

   //* Write records to stdout *
   void  report ( wchar_t** src, int recs, int indent ) ;
   void  report ( int* src, int recs, int indent ) ;
   void  report ( WinPos** src, int recs, int indent ) ;

   //* Development and Testing *
   void  SortCollated ( void ) ;
   void  shuffle ( int shuf ) ;
   void  sandbox ( void ) ;

   //** Public Data Members **
   locale *ioLocale ;   // pointer to "locale" object (text-formatting rules)
   char    srcFile[gsALLOCMIN] ; // source filespec
   wchar_t* extData ;   // pointer to dynamic allocation for external data capture
   wchar_t** extDPtr ;  // array of pointers to records in extData
   int     extSize ;    // size of extData buffer
   int     records ;    // number of records to be sorted
   srcType stype ;      // source data type
   bool    low2high,    // ascending/descending flag
           casesen,     // set if case-sensitive sort
           version ;    // set if request for app version
} ;